package com.yeejoin.precontrol.common.event;

import com.yeejoin.precontrol.common.dto.ProjectDto;
import com.yeejoin.precontrol.common.entity.hk.model.dto.HKRequestDto;
import org.springframework.context.ApplicationEvent;

/**
 * <p>
 *  新增项目同步海康平台区域
 * </p>
 *
 * @author songLei
 * @since 2021年5月8日09:29:09
 */
public class RegionAddEvent extends ApplicationEvent {
    private HKRequestDto hkRequestDto;
    public RegionAddEvent(Object source, ProjectDto projectDto) {
        super(source);
        HKRequestDto hkRequestDto = new HKRequestDto();
        hkRequestDto.setClientId(1);
        hkRequestDto.setDescription("区域描述");
        hkRequestDto.setParentIndexCode("1");
        hkRequestDto.setRegionIndexCode(projectDto.getProjectNum());
        hkRequestDto.setRegionName(projectDto.getName());
        hkRequestDto.setRegionCode("");
        hkRequestDto.setRegionType(12);
        this.hkRequestDto = hkRequestDto;
    }
    public HKRequestDto getHkRequestDto(){
        return this.hkRequestDto;
    }

}
