package com.yeejoin.precontrol.common.fileparser.product.html;


import com.yeejoin.precontrol.common.fileparser.utils.FileHelper;
import com.yeejoin.precontrol.common.fileparser.utils.Xlsx2Xls;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.converter.ExcelToHtmlConverter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Document;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.*;

@Slf4j
public class ExcelHtml implements AbstractHtml {

    @Override
    public void createHtml(String inputFile, String outputFile) throws Exception {
        InputStream is = null;
        /*
         * File sourcefile = new File(fileName); is = new FileInputStream(sourcefile);
         */

        try {
            File file = new File(inputFile);
            if (!file.exists()) {
                log.error("file not found:" + inputFile);
            }
            if (!FileHelper.isExcel2003(file)) {
                    Xlsx2Xls xlsx2Xls = new Xlsx2Xls(file);
                    xlsx2Xls.xlsx2XlsProgress();
            }
            file = new File(inputFile.replace(".xlsx", ".xls"));
            is = new FileInputStream(file);
            convertExcel2Html(is, outputFile);
        } finally {
            try {
                if (null != is) {
                    is.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 将xls(03版本)文件转换为html文件 @param fileName 需要转换的xls文件 @param outPutFile 转换为html文件的名称 @see @since
     * 1.7 @exception
     */
    private static void convertExcel2Html(InputStream is, String outputFile) {
        FileWriter out = null;
        try {
            // Document doc = ExcelToHtmlConverter.process( new File(fileName) );
            HSSFWorkbook workBook = new HSSFWorkbook(is);
            ExcelToHtmlConverter converter = new ExcelToHtmlConverter(
                    DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            converter.setOutputColumnHeaders(false);
            converter.setOutputRowNumbers(false);
            converter.setOutputLeadingSpacesAsNonBreaking(false);
            converter.setOutputRowNumbers(false);
            converter.processWorkbook(workBook);
            Document doc = converter.getDocument();

            out = new FileWriter(outputFile + ".html");
            DOMSource domSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(out);

            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty(OutputKeys.ENCODING, "GB2312");
            serializer.setOutputProperty(OutputKeys.INDENT, "no");
            serializer.setOutputProperty(OutputKeys.METHOD, "html"); // 指定输出文件的后缀名
            serializer.transform(domSource, streamResult);

            // FileHelper.parseCharset(outPutFile + ".html");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (null != out) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}

