package com.yeejoin.precontrol.common.fileparser.product.txt;

import org.apache.commons.io.FilenameUtils;

import java.io.*;

public class ImageText implements AbstractText {

    @Override
    public void createTxt(String inputFile, String outputFile) throws Exception {
        File file = new File(inputFile);
        String baseName = FilenameUtils.getBaseName(inputFile);
        try (InputStream is = new FileInputStream(file);
             OutputStream os = new FileOutputStream(outputFile.substring(0, outputFile.length() - baseName.length() - 1) + ".txt")) {
            byte[] buffer = new byte[1024];
            int result = -1;
            while (-1 != (result = is.read(buffer))) {
                os.write(buffer, 0, result);
            }
        }
    }
}

