package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.Reward;
import com.yeejoin.precontrol.common.vo.RewardAndRetributionListVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;
import com.yeejoin.precontrol.common.vo.RewardOrgCodeVo;
import com.yeejoin.precontrol.common.vo.RewardVo;

import java.util.List;
import java.util.Map;

/**
 * 奖励表 服务类
 *
 * @author duanwei
 * @date 2021-04-06
 */
public interface IRewardService extends IService<Reward> {

    List<RewardVo> rewardAllList(RewardVo rewardVo);

    IPage<RewardVo> pageInfo(CommonPageableDto pageable, RewardVo rewardVo);

    IPage<RewardVo> pageUserInfo(CommonPageableDto pageable, RewardVo rewardVo);

    IPage<RewardVo> listPageByUid(CommonPageableDto pageable, RewardVo rewardVo);

    RewardVo getRewardExchangeCount(RewardVo rewardVo);

    /**
     * 累计奖励总金额
     * @param personId
     * @return
     */
    String selectTotalMoney(Long personId);

    /**
     * 根据orgcode查询该orgcode下的人员奖励列表
     * @param pageable
     * @param rewardVo
     * @param orgCode
     * @return
     */
    IPage<RewardOrgCodeVo> listPageByOrgCode(StudioPageableDto pageable, RewardOrgCodeVo rewardVo, String orgCode);
    
    IPage<RewardOrgCodeVo> listBadPageByOrgCode(StudioPageableDto pageable, RewardOrgCodeVo rewardVo, String orgCode);

    /**
     * 根据人员id查询该人员的奖励详情列表
     * @param pageable
     * @param rewardVo
     * @return
     */
    IPage<RewardListVo> rewardUserListDetail(StudioPageableDto pageable, RewardListVo rewardVo);

    IPage<RewardAndRetributionListVo> rewardAndRetributionList(StudioPageableDto pageable, RewardAndRetributionListVo rewardVo);

    Object reportTotalMoney(String type);

    Map sumMoneyTotalByPersonId(Long personId);

    Integer dayCountByOrgCode(String orgCode, Long projectId);
}
