package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.mapper.PersonAscriptionMapper;
import com.yeejoin.precontrol.common.service.IPersonAscriptionService;
import com.yeejoin.precontrol.common.vo.PersonVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 人员归属信息 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class PersonAscriptionServiceImpl extends ServiceImpl<PersonAscriptionMapper, PersonAscription>
		implements IPersonAscriptionService {

	@Autowired
	PersonAscriptionMapper personAscriptionMapper;

	@Override
	public List<PersonVo> getUsers(Set<String> roleIds, List<Long> userListIds, Long projectId) {
		return personAscriptionMapper.getUsers(roleIds, userListIds, projectId);
	}

	@Override
	public List<PersonVo> getUsersByDept(Set<String> ids, Long companyId, Long departmentId, Long projectId) {
		return personAscriptionMapper.getUsersByDept(ids, companyId, departmentId, projectId);
	}
}
