package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.PersonInsuranceAttachment;
import com.yeejoin.precontrol.common.mapper.PersonInsuranceAttachmentMapper;
import com.yeejoin.precontrol.common.service.IPersonInsuranceAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 人员保险信息附件 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class PersonInsuranceAttachmentServiceImpl extends ServiceImpl<PersonInsuranceAttachmentMapper, PersonInsuranceAttachment> implements IPersonInsuranceAttachmentService {
    @Autowired
    PersonInsuranceAttachmentMapper insuranceAttachMapper;
    @Value("${fileserver.domain}")
    String fileServerUrl;

    @Override
    public void saveAttach(Long id, List<PersonInsuranceAttachment> attachment) {
        insuranceAttachMapper.delete(new QueryWrapper<PersonInsuranceAttachment>().eq("person_insurance_id", id));
        if (attachment != null) {
            attachment.forEach(a -> {
                a.setPersonInsuranceId(id);
                if (a.getAttachment() != null) {
                    a.setAttachment(a.getAttachment().replace(fileServerUrl, ""));
                }
                insuranceAttachMapper.insert(a);
            });
        }
    }
}
