package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.Reward;
import com.yeejoin.precontrol.common.enums.TaskStatusEnum;
import com.yeejoin.precontrol.common.mapper.RetributionMapper;
import com.yeejoin.precontrol.common.mapper.RewardMapper;
import com.yeejoin.precontrol.common.service.IRewardService;
import com.yeejoin.precontrol.common.utils.StringUtil;
import com.yeejoin.precontrol.common.vo.RewardAndRetributionListVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;
import com.yeejoin.precontrol.common.vo.RewardOrgCodeVo;
import com.yeejoin.precontrol.common.vo.RewardVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 奖励表 服务实现类
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Service
public class RewardServiceImpl extends ServiceImpl<RewardMapper, Reward> implements IRewardService {

	@Autowired
	private RewardMapper rewardMapper;

	@Autowired
	private RetributionMapper retributionMapper;


	@Override
	public List<RewardVo> rewardAllList(RewardVo rewardVo) {
		return rewardMapper.rewardAllList(rewardVo);
	}

	@Override
	public IPage<RewardVo> pageInfo(CommonPageableDto pageable, RewardVo rewardVo) {
		Page<RewardVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<RewardVo> pageInfo = rewardMapper.pageList(page, rewardVo);
		pageInfo.getRecords().forEach(p -> {
			if (p.getStatusCode() != null) {
				p.setStatusValue(TaskStatusEnum.getNameByType(Long.valueOf(p.getStatusCode())));
			}
		});
		return pageInfo;
	}

	@Override
	public IPage<RewardVo> listPageByUid(CommonPageableDto pageable, RewardVo rewardVo) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		if (StringUtil.isNotEmpty(rewardVo.getBeforeCreateDate())) {
			rewardVo.setBeforeCreateDate(rewardVo.getBeforeCreateDate() + " 00:00:00");
		}
		if (StringUtil.isNotEmpty(rewardVo.getEndCreateDate())) {
			rewardVo.setEndCreateDate(rewardVo.getEndCreateDate() + " 23:59:59");
		}
		Page<RewardVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		return rewardMapper.listPageByUid(page, rewardVo);
	}

	@Override
	public RewardVo getRewardExchangeCount(RewardVo rewardVo) {
		if (StringUtil.isNotEmpty(rewardVo.getBeforeCreateDate())) {
			rewardVo.setBeforeCreateDate(rewardVo.getBeforeCreateDate() + " 00:00:00");
		}
		if (StringUtil.isNotEmpty(rewardVo.getEndCreateDate())) {
			rewardVo.setEndCreateDate(rewardVo.getEndCreateDate() + " 23:59:59");
		}
		RewardVo result = rewardMapper.getRewardExchangeCount(rewardVo);
		return result != null ? result : new RewardVo();
	}

	/**
	 * 累计奖励总金额
	 *
	 * @param personId
	 * @return
	 */
	@Override
	public String selectTotalMoney(Long personId) {
		return rewardMapper.selectTotalMoney(personId);
	}

	/**
	 * 根据orgcode查询该orgcode下的人员奖励违章列表
	 *
	 * @param pageable
	 * @param rewardVo
	 * @param orgCode
	 * @return
	 */
	@Override
	public IPage<RewardOrgCodeVo> listPageByOrgCode(StudioPageableDto pageable, RewardOrgCodeVo rewardVo,
			String orgCode) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		Page<RewardOrgCodeVo> objectPage = new Page<RewardOrgCodeVo>(pageable.getCurrent(), pageable.getSize());
		return rewardMapper.listPageByOrgCode(objectPage, rewardVo, orgCode);
	}

	@Override
	public IPage<RewardListVo> rewardUserListDetail(StudioPageableDto pageable, RewardListVo rewardVo) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		Page<RewardListVo> objectPage = new Page<RewardListVo>(pageable.getCurrent(), pageable.getSize());
		return rewardMapper.rewardUserListDetail(objectPage, rewardVo);
	}

	@Override
	public IPage<RewardAndRetributionListVo> rewardAndRetributionList(StudioPageableDto pageable,
			RewardAndRetributionListVo rewardVo) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		Page<RewardAndRetributionListVo> rewardAndRetributionListVoPage = new Page<RewardAndRetributionListVo>(
				pageable.getCurrent(), pageable.getSize());
		return rewardMapper.rewardAndRetributionList(rewardAndRetributionListVoPage, rewardVo);
	}

	@Override
	public Object reportTotalMoney(String type) {
		// retributionAllTotal-所有惩罚总金额 retributionDayTotal-今日惩罚总金额
		// rewardAllTotal-所有奖励总金额 rewardDayTotal-今日奖励总金额
		Map<String, Object> map = new HashMap<String, Object>();
		String money = "0";
		switch (type) {
		case "retributionAllTotal":
			money = retributionMapper.selectAllMoneyTotal();
			break;
		case "retributionDayTotal":
			money = retributionMapper.selectDayMoneyTotal();
			break;
		case "rewardAllTotal":
			money = rewardMapper.selectAllMoneyTotal();
			break;
		case "rewardDayTotal":
			money = rewardMapper.selectDayMoneyTotal();
			break;
		}
		// map.put("money", "￥" + money);
		return map;
	}

	/**
	 * 根据orgcode查询该orgcode下的人员奖励违章列表
	 *
	 * @param pageable
	 * @param rewardVo
	 * @param orgCode
	 * @return
	 */
	@Override
	public IPage<RewardOrgCodeVo> listBadPageByOrgCode(StudioPageableDto pageable, RewardOrgCodeVo rewardVo,
			String orgCode) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		//name,ascend / name,descend
		if (!StringUtils.isEmpty(rewardVo.getSort())) {
			String[] s = rewardVo.getSort().split(",");
			rewardVo.setSortName(s[0]);
			rewardVo.setSortOrder(s[1] != null ? s[1].replace("end", "") : null);
		}
		Page<RewardOrgCodeVo> objectPage = new Page<RewardOrgCodeVo>(pageable.getCurrent(), pageable.getSize());
		return rewardMapper.listBadPageByOrgCode(objectPage, rewardVo, orgCode);
	}

	@Override
	public IPage<RewardVo> pageUserInfo(CommonPageableDto pageable, RewardVo rewardVo) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		if (!StringUtils.isEmpty(rewardVo.getSort())) {
			String[] s = rewardVo.getSort().split(",");
			rewardVo.setSortName(s[0]);
			rewardVo.setSortOrder(s[1] != null ? s[1].replace("end", "") : null);
		}
		Page<RewardVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<RewardVo> pageInfo = rewardMapper.pageUserInfo(page, rewardVo);
		pageInfo.getRecords().forEach(p -> {
			if (p.getStatusCode() != null) {
				p.setStatusValue(TaskStatusEnum.getNameByType(Long.valueOf(p.getStatusCode())));
			}
		});
		return pageInfo;
	}

	@Override
	public Map sumMoneyTotalByPersonId(Long personId) {
		return rewardMapper.sumMoneyTotalByPersonId(personId);
	}

	@Override
	public Integer dayCountByOrgCode(String orgCode, Long projectId) {
		return rewardMapper.dayCountByOrgCode(orgCode, projectId);
	}
}
