package com.yeejoin.precontrol.common.utils.hk;


import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import com.yeejoin.precontrol.common.component.InitContext;
import com.yeejoin.precontrol.common.constant.Const;
import com.yeejoin.precontrol.common.enums.media.MediaConfigKey;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: songLei
 * @Description: 海康SDK工具
 * @Date: 2021/4/29 14:36
 * @Version: 1.0
 */
public class HKSDKUtil {
    public HKSDKUtil(){}
    public static String doPost(String body,String url){
        /**设置平台参数，根据实际情况,设置host appKey appSecret 三个参数*/
        // artemis网关服务器ip端口
        ArtemisConfig.host = InitContext.memoryDataMap.get(MediaConfigKey.HK_PLATFORM_URL.getKey());
        // 秘钥appkey
        ArtemisConfig.appKey = InitContext.memoryDataMap.get(MediaConfigKey.HK_APP_KEY.getKey());
        // 秘钥appSecret
        ArtemisConfig.appSecret = InitContext.memoryDataMap.get(MediaConfigKey.HK_APP_SECRET.getKey());
        // "/api/video/v1/cameras/previewURLs"
        String previewURLsApi = InitContext.memoryDataMap.get(MediaConfigKey.HK_ARTEMIS_PATH.getKey()) + url;
        Map<String, String> path = new HashMap<String, String>(2) {
            {
                put(InitContext.memoryDataMap.get(MediaConfigKey.HK_PLATFORM_HTTP_PROTOCOL.getKey()), previewURLsApi);
            }
        };
        /**设置参数提交方式*/
        String contentType = Const.CONTENT_TYPE;
        /**调用接口 // post请求application/json类型参数*/
        String result = ArtemisHttpUtil.doPostStringArtemis(path, body, null, null, contentType, null);
        return result;
    }
}
