package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 待审核人员实体类
 */
@Data
public class ApprovalPersonVo implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "用户id")
    private Long id;
    @ImagePrefix
    @ApiModelProperty(value = "头像")
    private String headPhoto;
    @ApiModelProperty(value = "身份证头像面")
    @ImagePrefix
    private String idCardHead;
    @ApiModelProperty(value = "身份证国徽面")
    @ImagePrefix
    private String idCardNational;
    @ApiModelProperty(value = "平台账号")
    private String accountName;
    @ApiModelProperty(value = "用户姓名")
    private String userName;
    @ApiModelProperty(value = "公司名称")
    private String companyName;
    @ApiModelProperty(value = "公司id")
    private Long companyId;
    @ApiModelProperty(value = "项目id")
    private Long projectId;
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "审核状态：,1-待审核，2-审核拒绝，3-分包商审核通过，4-项目部审核通过")
    private Integer verifyStatus;
    @ApiModelProperty(value = "审核时间")
    private Date createDate;

    @ApiModelProperty(value = "证件类型")
    private Long idType;

    @ApiModelProperty(value = "证件号码")
    private String idNumber;

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @ApiModelProperty(value = "工种名称")
    private String postName;
}
