package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: duanwei
 * @date: 2020-07-21 14:00
 **/
@Data
public class TaskPersonAndImageInfo {
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    @ApiModelProperty(value = "人员id")
    private Long personId;
    @ApiModelProperty(value = "执行任务人ID")
    private Long taskPersonId;
    @ApiModelProperty(value = "发起人名称")
    private String createPersonName;
    @ApiModelProperty(value = "人员名称")
    private String personName;
    @ApiModelProperty(value = "0主持人，1交底人，2施工负责人，3安全员，4交底人员，5记录人，6技术员，7工程人员，8施工人员，9违章人员 10 分包商负责人\n" +
            "        // 11审核人 12违规发起人 13平台分包商安全员（项目安全员）  99 发布人")
    private Long type;
    @ApiModelProperty(value = "阅读状态 0未读 1已读")
    private Long readStatus;
    @ApiModelProperty(value = "文件路径")
    @ImagePrefix
    private List<TaskFileVo> filePath;
    @ApiModelProperty(value = "文件路径通过时间分组")
    @ImagePrefix
    private Map<Date,List<TaskFileVo>> timeFilePath;
    @ApiModelProperty(value = "上传时间")
    private Date createTime;
    @ApiModelProperty(value = "任务的状态")
    private String status;
    @ApiModelProperty(value = "任务的状态")
    private String statusName;
    @ApiModelProperty(value = "0主持人，1交底人，2施工负责人，3安全员，4交底人员，5记录人，6技术员，7工程人员，8施工人员，9违章人员 10 分包商负责人\n" +
            "        // 11审核人 12违规发起人 13平台分包商安全员（项目安全员）  99 发布人")
    private Long taskPersonRoleType;

    @ApiModelProperty(value = "任务人类型")
    private String taskPersonRoleTypeName;


}
