package com.yeejoin.amos.supervision.common.enums;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author DELL
 * 防火监督任务排序
 */

public enum OrderByEnum {
    /**
     * 防火监督任务排序
     */
    TIME_DESC("时间倒序", "1", "beginTime desc"),
    TIME_ASC("时间正序", "2", "beginTime asc"),
    PLAN_TASK_NUM_ASC("计划检查项数正序", "3", "taskPlanNum asc");

    /**
     * 名字
     */
    private String name;
    /**
     * 编号
     */
    private String code;

    /**
     * 条件
     */
    private String oderBy;

    public String getOderBy() {
        return oderBy;
    }

    public void setOderBy(String oderBy) {
        this.oderBy = oderBy;
    }

    OrderByEnum(String name, String code, String oderBy) {
        this.code = code;
        this.name = name;
        this.oderBy = oderBy;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(OrderByEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put(e.getCode(), e.getName());
            return map;
        }).collect(Collectors.toList());
    }

    public static OrderByEnum getEumByCode(String code) throws Exception {
        Optional<OrderByEnum> op = Arrays.stream(OrderByEnum.values()).filter(e->e.getCode().equals(code)).findFirst();
        return op.orElseThrow(()->new Exception("非法的条件"));
    }

}
