package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PointLevelEnum {
	FIRSTLEVEL("一级", 1),
	SECONDLEVEL("二级", 2),
	THREELEVEL("三级", 3),
	FOURLEVEL("四级", 4),
	FIVElEVEL("五级", 5);
	
	private String name;
	
	private int value;
	
	private PointLevelEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}
	

	public static String getName(int value) {
		for (PointLevelEnum c : PointLevelEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (PointLevelEnum c : PointLevelEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return 0;
	}


	public static PointLevelEnum getEnum(int value) {
		for (PointLevelEnum c : PointLevelEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static PointLevelEnum getEnum(String name) {
		for (PointLevelEnum c : PointLevelEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PointLevelEnum c: PointLevelEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}
	
	public static List<Map<String, String>> getEnumList() {
		List<Map<String, String>> enumList = new ArrayList<>();
		for (PointLevelEnum c: PointLevelEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("value", c.getValue() +"");
			map.put("name", c.getName());
			enumList.add(map);
		}
		return enumList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}
}
