package com.yeejoin.amos.avic.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.avic.face.model.AvicCustomPathModel;
import com.yeejoin.amos.avic.face.service.AvicCustomPathService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Date;
import java.util.UUID;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2022-03-28
 */

@RestController
@TycloudResource(module = "avic", value = "avicCustomPath")
@RequestMapping(value = "/v1/avic/AvicCustomPath")
@Api(tags = "avic-")
public class AvicCustomPathResource {

	@Value("${avic.webservice.path}")
	String webserviceUrl;
	
	private final Logger logger = LogManager.getLogger(AvicCustomPathResource.class);
	@Autowired
	private AvicCustomPathService simpleService;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "创建")
	@RequestMapping(value = "", method = RequestMethod.POST)
	public ResponseModel<AvicCustomPathModel> create(@RequestBody AvicCustomPathModel model) {
		model.setAgencyCode(RequestContext.getAgencyCode());
		model.setRecDate(new Date());
		model.setRecUserId(RequestContext.getExeUserId());
		model.setId(String.valueOf(UUID.randomUUID().getLeastSignificantBits()));
//		postConfig(model);
		model = simpleService.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	public void postConfig(AvicCustomPathModel model) {
		JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
//		JaxWsProxyFactoryBean factoryBean = new JaxWsProxyFactoryBean();
//		factoryBean.setServiceClass(AvicCustomPathModel.class);
//		factoryBean.setAddress(webserviceUrl);
		Client client = dcf.createClient(webserviceUrl);
		try {
			client.invoke("transferPathConfig", model);
		} catch (java.lang.Exception e) {
			e.printStackTrace();
		}
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "更新")
	@RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
	public ResponseModel<AvicCustomPathModel> update(@RequestBody AvicCustomPathModel model,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		postConfig(model);
		return ResponseHelper.buildResponse(simpleService.updateWithModel(model));
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除")
	@RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
	public ResponseModel<Boolean> delete(@PathVariable("ids") String[] ids) {
		for (String id: ids) {
			simpleService.deleteBySeq(Long.parseLong(id));
		}
		return ResponseHelper.buildResponse(true);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询单个对象")
	@RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.GET)
	public ResponseModel<AvicCustomPathModel> seleteOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(simpleService.queryBySeq(sequenceNbr));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "分页查询")
	@RequestMapping(value = "/page", method = RequestMethod.GET)
	public ResponseModel<Page> queryForPage(@RequestParam(value = "searchValue") String pathName,
			@RequestParam(value = "current") int current, @RequestParam(value = "size") int size) {
		Page page = new Page();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(simpleService.queryForAvicCustomPathPage(page, pathName, RequestContext.getAgencyCode()));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "列表查询")
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	public ResponseModel selectForList() {
		return ResponseHelper.buildResponse(simpleService.queryForAvicCustomPathList(RequestContext.getAgencyCode()));
	}

}
