package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireDangerDayStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireDangerDayStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 换流站隐患日统计
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "换流站隐患日统计Api")
@RequestMapping(value = "/fire-danger-day-statistics")
public class FireDangerDayStatisticsController extends BaseController {

    @Autowired
    FireDangerDayStatisticsServiceImpl fireDangerDayStatisticsServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "换流站隐患日统计列表全部数据查询", notes = "换流站隐患日统计列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireDangerDayStatisticsDto>> selectForList() {
        return ResponseHelper.buildResponse(fireDangerDayStatisticsServiceImpl.queryForFireDangerDayStatisticsList());
    }
}
