package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireFmeaStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireFmeaStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 发生率/严重度矩阵统计表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "发生率-严重度矩阵统计表Api")
@RequestMapping(value = "/fire-fmea-statistics")
public class FireFmeaStatisticsController extends BaseController {

    @Autowired
    FireFmeaStatisticsServiceImpl fireFmeaStatisticsServiceImpl;


    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "发生率-严重度矩阵统计", notes = "发生率-严重度矩阵统计")
    @GetMapping(value = "/{stationCode}/list")
    public ResponseModel<List<FireFmeaStatisticsDto>> selectForList(
            @ApiParam(value = "换流站code", required = true) @PathVariable String stationCode) {
        return ResponseHelper.buildResponse(fireFmeaStatisticsServiceImpl.queryForFireFmeaStatisticsList(stationCode));
    }
}
