package com.yeejoin.amos.boot.module.ccs.biz.controller;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.util.StrUtil;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireStationInfoDto;
import com.yeejoin.amos.boot.module.ccs.api.enums.StationOrderByTypeEnum;
import com.yeejoin.amos.boot.module.ccs.api.vo.CarInfoVO;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireStationInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 站端信息表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "站端信息表Api")
@RequestMapping(value = "/fire-station-info")
public class FireStationInfoController extends BaseController {

    @Autowired
    FireStationInfoServiceImpl fireStationInfoServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "站端信息表列表", notes = "站端信息表列表")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireStationInfoDto>> selectForList(
            @ApiParam(value = "排序条件") @RequestParam(required = false) String orderBy) throws Exception {
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.queryForFireStationInfoList(orderBy));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "站端信息详情", notes = "站端信息详情")
    @GetMapping(value = "/{stationCode}/detail")
    public ResponseModel getOne(@PathVariable String stationCode) {
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.getOneByCode(stationCode));
    }

    /**
     * 日常动态左侧警情统计top10
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "日常动态左侧警情统计top10", notes = "日常动态左侧警情统计top10")
    @GetMapping(value = "/getStationSafetyListByCode")
    public ResponseModel<List<FireStationInfoDto>> stationSafetyList(
            @ApiParam(value = "换流站编码") @RequestParam(required = false) String stationCode,
            @ApiParam(value = "数量") @RequestParam(required = false) Integer top) {
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.queryStationAlarmListByCode(stationCode, top));
    }

    /**
     * 日常动态左侧警情统计top10
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "中间上部分告警数量统计", notes = "中间上部分告警数量统计")
    @GetMapping(value = "/getAlarmNumByDate")
    public ResponseModel<Map<String, Integer>> getAlarmNumByDate(
            @ApiParam(value = "换流站编码") @RequestParam(required = false) String stationCode) {
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.getAlarmNumByDate(stationCode));
    }


    /**
     * 日常动态左侧警情统计top10
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "换流站24小时警情数量", notes = "换流站24小时警情数量")
    @GetMapping(value = "/getAlarmNumByDateTimePeriod")
    public ResponseModel<Map<String, List<String>>> getAlarmNumByDateTimePeriod(
            @ApiParam(value = "换流站编码") @RequestParam(required = false) String stationCode,
            @ApiParam(value = "开始时间,格式：" + DatePattern.NORM_DATETIME_PATTERN, required = true) @RequestParam(required = true) String beginDateTime,
            @ApiParam(value = "结束时间,格式：" + DatePattern.NORM_DATETIME_PATTERN, required = true) @RequestParam(required = true) String endDateTime) {
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.getAlarmNumByDateTimePeriod(stationCode, beginDateTime, endDateTime));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询指定时间段的告警趋势", notes = "查询指定时间段的告警趋势")
    @GetMapping(value = "/getAlarmTrendByDatePeriod")
    public ResponseModel getAlarmTrendByDatePeriod(
            @ApiParam(value = "开始日期,格式：" + DatePattern.NORM_DATE_PATTERN, required = true) @RequestParam(value = "beginDate") String beginDate,
            @ApiParam(value = "结束日期,格式：" + DatePattern.NORM_DATE_PATTERN, required = true) @RequestParam(value = "endDate") String endDate,
            @ApiParam(value = "换流站编号") @RequestParam(required = false) String stationCode) {
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.getAlarmTrendByDatePeriod(stationCode, beginDate, endDate));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据换流站code统计消防车", notes = "根据换流站code统计消防车")
    @GetMapping(value = "/getCarInfoByStationCode")
    public ResponseModel<List<CarInfoVO>> getCarInfoByStationCode(@ApiParam(value = "换流站编号", required = true) @RequestParam(required = true) String stationCode) {
        if (StrUtil.isEmpty(stationCode)) {
            throw new BadRequest("换流站编号不能为空");
        }
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.getCarInfoByStationCode(stationCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据换流站code统计消防系统状态", notes = "根据换流站code统计消防系统状态")
    @GetMapping(value = "/getFireSystemByStationCode")
    public ResponseModel<List<Map<String, String>>> getFireSystemByStationCode(@ApiParam(value = "换流站编号", required = true) @RequestParam(required = true) String stationCode) {
        if (StrUtil.isEmpty(stationCode)) {
            throw new BadRequest("换流站编号不能为空");
        }
        return ResponseHelper.buildResponse(fireStationInfoServiceImpl.getFireSystemByStationCode(stationCode));
    }
}
