package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.vo.EquipmentAccountFilterVo;
import com.yeejoin.equipmanage.common.vo.EquipmentHistoryVo;
import com.yeejoin.equipmanage.service.EquipmentAccountService;
import com.yeejoin.equipmanage.service.ICarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;
import java.util.Map;

/**
 * @author zjw
 * @date 2020-09-17
 */
@RestController
@Api(tags = "装备台账Api")
@RequestMapping(value = "/equipmentAccount", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentAccountController {

    @Autowired
    private EquipmentAccountService equipmentAccountService;
    @Autowired
    @Lazy
    ICarService iCarService;

    @GetMapping(value = "/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取装备台账信息", notes = "获取装备台账信息")
    public Map<String, Object> getccounAList(
            @RequestParam(value = "eType") String eType,
            @RequestParam(value = "eName") String eName,
            @RequestParam(value = "spage") int spage,
            @RequestParam(value = "pageSize") int pageSize) {
        return equipmentAccountService.getAccounList(eType, eName, spage, pageSize);
    }


    @GetMapping(value = "/nameList")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取装备名称", notes = "获取装备名称")
    public List<EquipmentAccountFilterVo> getNameList(@RequestParam(value = "id") String id) {
        return equipmentAccountService.getNameList(id);
    }

    @GetMapping(value = "/list-showMoreCar")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取装备台账信息-车辆", notes = "获取装备台账信息-车辆")
    public Map<String, Object> getMoreCarList(
            @RequestParam(value = "carNum") String carNum,
            @RequestParam(value = "spage") int spage,
            @RequestParam(value = "pageSize") int pageSize,
            @RequestParam(value = "equipmentName") String equipmentName,
            @RequestParam(value = "accType") String accType
    ) {
        return equipmentAccountService.getMoreCarList(carNum, spage, pageSize, equipmentName, accType);
    }


    @GetMapping(value = "/list-showMoreAcc")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取装备台账信息-装备", notes = "获取装备台账信息-装备")
    public Map<String, Object> getMoreAccList(
            @RequestParam(value = "code") String code,
            @RequestParam(value = "spage") int spage,
            @RequestParam(value = "pageSize") int pageSize,
            @RequestParam(value = "equipmentName") String equipmentName,
            @RequestParam(value = "accType") String accType
    ) {
        return equipmentAccountService.getMoreAccList(code, spage, pageSize, equipmentName, accType);
    }

    @GetMapping(value = "/getCar")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询车辆详情", notes = "根据id查询车辆详情")
    public Car selectById( @RequestParam(value = "id") Long id) {
        return iCarService.selectOneById(id);
    }


    @GetMapping(value = "/history")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询车辆详情", notes = "根据id查询车辆详情")
    public   List<EquipmentHistoryVo> selectHistoryById(@RequestParam(value = "id") Long id) {
        return equipmentAccountService.selectHistoryById(id);
    }

    @GetMapping(value = "/accData")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询装备详情", notes = "根据id查询装备详情")
    public   Map<String, Object>  getAccData(@RequestParam(value = "id") Long id) {
        return equipmentAccountService.getAccData(id);
    }



}
