package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.FormGroupColumn;
import com.yeejoin.equipmanage.service.IFormGroupColumnService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;


/**
 * 动态表单控制器
 *
 * @author gaojianqiang
 * @date 2022-10-09
 */
@RestController
@Api(tags = "动态表单分组列Api")
@RequestMapping(value = "/form-group-column", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FormGroupColumnController extends AbstractBaseController {


    @Autowired
    IFormGroupColumnService formGroupColumnService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通过分组code查询列信息", notes = "通过分组code查询列信息")
    @RequestMapping(value = "/queryByGroup", method = RequestMethod.GET)
    public List<FormGroupColumn> queryByGroup(@RequestParam String groupCode) {
        return formGroupColumnService.queryByGroup(groupCode);
    }

}


