package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.Industry;
import com.yeejoin.equipmanage.service.IIndustryService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;


@RestController
@Api(tags = "行业分类Industry")
@RequestMapping(value = "/industry")
public class IndustryController {
    @Autowired
    IIndustryService industryService;

    @GetMapping(value = "/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public List<Industry> listAll() {
        return industryService.list();
    }
}
