package com.yeejoin.equipmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.equipmanage.common.entity.publics.CommonResponse;
import com.yeejoin.equipmanage.common.entity.res.DutyRes;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.remote.DutyFeign;
import com.yeejoin.equipmanage.remote.RemoteSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zjw
 * @date 2020-11-06
 */
@RestController
@Api(tags = "值班人员信息Api")
@RequestMapping(value = "/rightsideBar", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class RightsideBarController {

    @Autowired
    DutyFeign dutyFeign;
    @Autowired
    RemoteSecurityService remoteSecurityService;

    @GetMapping(value = "/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取值班人员信息", notes = "姓名，电话")
    public ResponseModel getList(HttpServletRequest request) {
        FeignClientResult<AgencyUserModel> feignClientResult = Privilege.agencyUserClient.getme();
        String orgCode = feignClientResult.getResult().getCompanys().get(0).getOrgCode();
        Date curDate = new Date();
        JSONObject param = new JSONObject();
        param.put("dutyDate", curDate);
        String token = request.getHeader("token");
        String product = request.getHeader("product");
        String appKey = request.getHeader("appKey");
        return CommonResponseUtil.success(dutyFeign.dutyListByDate(appKey, product, orgCode, token, param.toJSONString()));
    }

    @GetMapping(value = "/getRiskSourceList")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取视频页面值班人员信息列表", notes = "姓名，电话")
    public List<DutyRes> getRiskSourceList(HttpServletRequest request) {
        FeignClientResult<AgencyUserModel> feignClientResult = Privilege.agencyUserClient.getme();
        String orgCode = feignClientResult.getResult().getCompanys().get(0).getOrgCode();
        Date curDate = new Date();
        JSONObject param = new JSONObject();
        param.put("dutyDate", curDate);
        String token = request.getHeader("token");
        String product = request.getHeader("product");
        String appKey = request.getHeader("appKey");
        CommonResponse commonResponse = dutyFeign.dutyListByDate(appKey, product, orgCode, token, param.toJSONString());
        List<DutyRes> list=null;
        List<DictionarieValueModel> postTypeList = remoteSecurityService.listDictionaryByDictCode("postType");
        Map<String, String> postTypeMap= postTypeList.stream().collect(Collectors.toMap(DictionarieValueModel::getDictDataKey, DictionarieValueModel::getDictDataValue));
        if(("SUCCESS").equals(commonResponse.getResult())){
            list = (List)commonResponse.getDataList();
            list.forEach(x->{
                x.setPostName(postTypeMap.get(x.getPostType()));
            });
        }
        return list;
    }

}
