package com.yeejoin.equipmanage.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.utils.CommonPageable;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: CarStatisticController
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2024/7/26 15:17
 */
@RestController
@Api(tags = "消防系统统计Api")
@RequestMapping(value = "/center/system", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Slf4j
public class SystemStatisticController extends AbstractBaseController {

    @Autowired
    FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    IotFeign iotFeign;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/status", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取系统状态统计信息", notes = "获取系统状态统计信息")
    public ResponseModel getSystemInfo(@RequestParam(required = false) String bizOrgCode) {
        Map<String, Object> map = fireFightingSystemMapper.getCenterEquipState(bizOrgCode);
        BigDecimal normal = new BigDecimal(String.valueOf(map.getOrDefault("normalNum", "0")));
        BigDecimal total = new BigDecimal(String.valueOf(map.getOrDefault("total", "0")));
        if (total.compareTo(BigDecimal.ZERO) == 0) {
            map.put("abs", BigDecimal.ZERO);
        } else {
            map.put("abs", normal.divide(total, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP));
        }
        return CommonResponseUtil.success(map);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/system-types-num-stats", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取系统类型数据统计", notes = "获取系统类型数据统计")
    public ResponseModel getSystemTypesNumStats(@RequestParam(required = false) String bizOrgCode) {
        List<Map<String, Object>> list = fireFightingSystemMapper.getSystemTypesNumStats(bizOrgCode);
        return CommonResponseUtil.success(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/system-types", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取系统类型列表", notes = "获取系统类型列表")
    public ResponseModel getSystemTypes(@RequestParam(required = false) String bizOrgCode) {
        List<Map<String, Object>> list = fireFightingSystemMapper.getSystemTypes(bizOrgCode);
        return CommonResponseUtil.success(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取系统信息", notes = "获取系统信息")
    public ResponseModel getSystemPage(CommonPageable commonPageable,
                                       @RequestParam(required = false) String bizOrgCode,
                                       @RequestParam(required = false) String systemType,
                                       @RequestParam(required = false) String systemState,
                                       @RequestParam(required = false) String sorter
    ) {
        String sortField = "", sortOrder = "";
        if (org.springframework.util.StringUtils.hasText(sorter)) {
            sortField = sorter.split("@")[0];
            sortOrder = sorter.split("@")[1];
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        Page<Map<String, Object>> page1 = fireFightingSystemMapper.getSystemInfoPage(page, bizOrgCode, systemType, systemState, sortField, sortOrder);
        return CommonResponseUtil.success(page1);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/iot/statistic", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取物联信息", notes = "获取物联信息")
    public ResponseModel getIotInfo(@RequestParam(required = false) String bizOrgCode) {
        Map<String, Object> map = fireFightingSystemMapper.getIotInfo(bizOrgCode);
        // 获取当天开始时间（0点0分0秒）
        Date startOfDay = DateUtil.beginOfDay(new Date());
        String startOfDayStr = DateUtil.formatDateTime(startOfDay);

        // 获取当天结束时间（23点59分59秒）
        Date endOfDay = DateUtil.endOfDay(new Date());
        String endOfDayStr = DateUtil.formatDateTime(endOfDay);
        ResponseModel<Map<String, Object>> mapResponseModel = iotFeign.queryIotDataNum(startOfDayStr, endOfDayStr, bizOrgCode);
        if (200 == mapResponseModel.getStatus() ) {
            Map<String, Object> result = mapResponseModel.getResult();
            Object totalNum = result.get("totalNum");
            map.put("indexMonitorNum", totalNum);
        }
        return CommonResponseUtil.success(map);
    }
}
