package com.yeejoin.equipmanage.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.enums.ConfigPageTopicEnum;
import com.yeejoin.equipmanage.service.IEquipmentSpecificIndexSerivce;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivce;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import com.yeejoin.equipmanage.service.MqttSendGateway;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqxListener;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Slf4j
@Component
public class IntegratePageDataListener extends EmqxListener {

    @Autowired
    IFireFightingSystemService fireFightingSystemService;

    @Autowired
    IEquipmentSpecificSerivce equipmentSpecificService;

    @Autowired
    IEquipmentSpecificIndexSerivce equipmentSpecificIndexService;

    static MqttSendGateway mqttSendGateway;

    @Autowired
    public void setMqttSendGateway(MqttSendGateway mqttSendGateway) {
        IntegratePageDataListener.mqttSendGateway = mqttSendGateway;
    }

    @Override
    public void processMessage(String topic, MqttMessage message) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("收到消息主题：{},消息内容：{}", topic, message.toString());
        }
        Map<String, Object> msg = JSON.parseObject(message.toString());
        if (msg.containsKey("request")) {
            String split = "/";
            if (topic.contains(split)) {
                String code = topic.substring(topic.indexOf(split) + 1);
                fireFightingSystemService.integrationPageSysData(code, false);
            }
        } else if (ConfigPageTopicEnum.EQUIP_INDICATOR.getTopic().equalsIgnoreCase(topic)
                || ConfigPageTopicEnum.EQUIP_MULTI_INDICATOR.getTopic().equalsIgnoreCase(topic)) {
            this.initializeIntegrationPageData(topic, msg);
        }
    }

    private void initializeIntegrationPageData(String topic, Map<String, Object> message) {
        Object codes = message.get("codes");

        // 设备绑定多测点：codes为"equipment_specific_id"
        if (ConfigPageTopicEnum.EQUIP_MULTI_INDICATOR.getTopic().equalsIgnoreCase(topic) && Objects.nonNull(codes) && !ObjectUtils.isEmpty(codes)) {
            List<String> equipIds = JSON.parseArray(String.valueOf(codes), String.class);
            List<EquipmentSpecificIndex> indices = equipmentSpecificIndexService.list(
                    Wrappers.<EquipmentSpecificIndex>lambdaQuery()
                            .select(EquipmentSpecificIndex::getEquipmentSpecificId, EquipmentSpecificIndex::getEquipmentIndexKey, EquipmentSpecificIndex::getValue)
                            .in(EquipmentSpecificIndex::getEquipmentSpecificId, equipIds)
                            .isNotNull(EquipmentSpecificIndex::getValue)
                            .ne(EquipmentSpecificIndex::getValue, "")
                            .orderByDesc(EquipmentSpecificIndex::getEmergencyLevel)
            );
            Map<Long, List<EquipmentSpecificIndex>> groupedIndices = indices.stream().collect(Collectors.groupingBy(EquipmentSpecificIndex::getEquipmentSpecificId));

            JSONObject emqMessage;
            for (Map.Entry<Long, List<EquipmentSpecificIndex>> entry : groupedIndices.entrySet()) {
                Long equipmentSpecificId = entry.getKey();
                List<EquipmentSpecificIndex> specificIndexList = entry.getValue();

                List<HashMap<String, String>> valuedIndexes = specificIndexList.stream().map(index -> new HashMap<String, String>() {{
                    put("key", index.getEquipmentIndexKey());
                    put("value", index.getValue());
                }}).collect(Collectors.toList());
                emqMessage = new JSONObject() {{
                    this.put("code", String.valueOf(equipmentSpecificId));
                    this.put("valuedIndexes", valuedIndexes);
                }};
                mqttSendGateway.sendToMqtt(ConfigPageTopicEnum.EQUIP_MULTI_INDICATOR.getTopic(), emqMessage.toJSONString());
            }
        }
        // 单测点：codes为"equipment_specific_index_id"
        if (ConfigPageTopicEnum.EQUIP_INDICATOR.getTopic().equalsIgnoreCase(topic) && Objects.nonNull(codes) && !ObjectUtils.isEmpty(codes)) {
            List<String> ids = JSON.parseArray(String.valueOf(codes), String.class);
            List<EquipmentSpecificIndex> indices = equipmentSpecificIndexService.list(
                    Wrappers.<EquipmentSpecificIndex>lambdaQuery()
                            .select(EquipmentSpecificIndex::getId, EquipmentSpecificIndex::getEquipmentIndexKey, EquipmentSpecificIndex::getValue)
                            .in(EquipmentSpecificIndex::getId, ids)
            );

            JSONObject emqMessage;
            for (EquipmentSpecificIndex index : indices) {
                emqMessage = new JSONObject() {{
                    this.put("code", String.valueOf(index.getId()));
                    this.put("value", index.getValue());
                    this.put("status", index.getValue());
                }};
                mqttSendGateway.sendToMqtt(ConfigPageTopicEnum.EQUIP_INDICATOR.getTopic(), emqMessage.toJSONString());
            }
        }
    }
}
