package com.yeejoin.equipmanage.listener;

import com.yeejoin.equipmanage.common.utils.EnumsUtils;
import com.yeejoin.equipmanage.event.SyncRiskEvent;
import com.yeejoin.equipmanage.operation.SyncRiskOperator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

/**
 * @Author: songLei
 * @Description: 同步风险区域监听器
 * @Date: 2020/12/29 17:20
 * @Version: 1.0
 */
@Slf4j
@Component
public class SyncRiskListener implements ApplicationListener<SyncRiskEvent> {
    /**
     * @param event 事件
     * @Description 等待事务提交完成之后进行业务处理，事务失败，则不监听事件
     * @Date 2020/12/29 18:59
     */
    @Override
    public void onApplicationEvent(SyncRiskEvent event) {
        log.info("监听到同步风险区域事件--事件类型为:{}", event.operation());
        // 如果isRisk是tree进行同步风险区域操作，调用fegin接口实现
        // 根据operation(操作类型作相应业务)
        Optional<SyncRiskOperator> m = EnumsUtils.getEnumObject(SyncRiskOperator.class,
                e -> e.getType().equals(String.valueOf(event.operation())));
        calculate(event.map(), m.get());
    }

    public void calculate(Map<String, Object> map, SyncRiskOperator operator) {
        operator.apply(map);
    }
}
