package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.entity.FireVehicle;
import com.yeejoin.equipmanage.common.dto.CarFusionDto;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.dto.CarDto;
import com.yeejoin.equipmanage.common.entity.dto.CarEquipAlarmInfoDto;
import com.yeejoin.equipmanage.common.entity.dto.CarEquipStateInfoDto;
import com.yeejoin.equipmanage.common.entity.vo.CarIndexVo;
import com.yeejoin.equipmanage.common.entity.vo.CarPropertyVo;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentOnCarAppVO;
import com.yeejoin.equipmanage.common.vo.EquipStateOnCarVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * 消防车信息 Mapper 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface CarMapper extends BaseMapper<Car> {

    List<Car> page(@Param("offset") long offset, @Param("size") long size, @Param("car") Car car);

    int count(@Param("car") Car car);

    List<EquipmentOnCarAppVO> selectEquipmentOnCarAppList(@Param("carId") Long carId);

    List<CarIndexVo> getCarsIotInfo(@Param("orgCode") String orgCode);

    List<CarIndexVo> getCarIndexs(@Param("carId") Long carId);

    List<EquipStateOnCarVo> getCarEquipmentStateByCarId(Long id);

    List<String> getIotCodeList(@Param("id") String id);

    Car getCarsByIotCode(@Param("iotCode") String iotCode);
    
    Car getCarsByIotCodeExcludeCarId(@Param("iotCode") String iotCode, @Param("carId") Long carId);

    List<CarIndexVo> getCarsInfoByOrgCode(@Param("orgCode") String orgCode);

    List<CarIndexVo> getCarsIotInfoByIotCode(@Param("iotCode") String iotCode);

    List<CarIndexVo> getCarIotCodeLists();

    String getUtilName(@Param("id") Long id);

    FireVehicle getFireVehicleDetailById(Long id);

    List<Map<String, Object>> getCarNumGroupByTeamId();

    List<CarDto> getTeamCarList(String sequenceNbr ,Long id, String carState);

    List<CarPropertyVo> getCarPropertyList(List<Long> idList, Long teamId, String nameKeys, Integer isIot);

    /**
     * 获取车辆 装备、灭火药剂列表及数量
     *
     * @param carId 车辆id
     * @return
     */
    List<Map<String, Object>> getCarResourceMapList(Long carId);
    
    Map<String, Object> getCarStateInfoByCarNum(@Param("carNum")String carNum);


    List<Car> equipmentCarList(@Param("offset") long offset, @Param("size") long size,
                               @Param("teamId") Long teamId, @Param("name") String name,
                               @Param("code")String code, @Param("id") Long id, @Param("isNo") Boolean isNo);
    int equipmentCarListcount(Long teamId, String name,String code,Long id,Boolean isNo);

    List<CarFusionDto> selectCarAndCarProperty();


    List<Map<String, Object>> queryCompanyCarStaData();

    List<Map<String, Object>> queryCompanyIotStaData();

    List<Map<String, Object>> getCarState();

    List<Map<String, Object>> getFirePowerInfo();
    Integer getCarCategoryCountByCategoryID(@Param("categoryID")Long categoryID,@Param("orgCode")String orgCode);
    List<CarEquipStateInfoDto> getCarEquipStateInfo();
    List<CarEquipAlarmInfoDto> getCarEquipAlarmInfo(Integer batteryNumber);

    void updateStatusByIds(List<String> carIds, String status);
    @Update("update wl_car set latitude = #{latitude} , longitude = #{longitude} where iot_code = #{iotCode}")
    void updateCarLocationByIotCode(String iotCode,Double latitude,Double longitude);

    Page<Map<String, Object>> getCarInfoPage(Page page, @Param("bizOrgCode") String bizOrgCode, @Param("sortField") String sortField, @Param("sortOrder") String sortOrder);

    Page<Map<String, Object>> getStationCarInfoPage(Page page, @Param("bizOrgCode") String bizOrgCode);
}
