package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.equipmanage.common.entity.EquipmentIndex;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIndexVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface EquipmentIndexMapper extends BaseMapper<EquipmentIndex> {
    /**
     * 分页
     * @param page
     * @param id
     * @param groupName
     * @return
     */
    IPage<EquipmentIndexVO> getPage(IPage<EquipmentIndex> page, @Param("id") Long id, @Param("groupName")String groupName);

    /**
     * @param id
     * @return
     */
    List<EquipmentIndexVO> getPerfQutoaList(@Param("id") Long id);

    /**
     * 查询单个
     * @param id
     * @return
     */
    EquipmentIndexVO getOnePrefQuota(@Param("id") Long id);

    /**
     * 查重
     * @param id
     * @param dataId
     * @param fId
     * @return
     */
    int checkName(@Param("id")  Long id,@Param("dataId")Long dataId,@Param("fId")Long fId);
    int  updateE(Long id);

    /**
     * 保存
     * @param perfQuotaVO
     * @return
     */
    int savePerfQuota(EquipmentIndexVO perfQuotaVO);

    /**
     * 查询计量单位名称是否重复
     * @param unitName
     * @return
     */
    int checkUnit(@Param("unitName")String unitName);

    List<Map<String, Object>> queryEquipmentIndexListByEquipId(@Param("equipmentId") Long equipmentId,
                                                          @Param("start") Long start, @Param("page") Long page);

    int  queryEquipmentIndexCountByEquipId(@Param("equipmentId") Long equipmentId);

    List<EquipmentIndexVO> getEquipmentIndexByIot();

    List<EquipmentIndex> getPerfQutoaIotList(Long id);

    List<String> getGruopName(Long equipmentId);

    EquipmentIndex  getMessage(@Param("equipmentSpecificId")Long equipmentSpecificId, @Param("equipmentIndexKey")String equipmentIndexKey);
}
