package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.dto.MaintenanceResourceDto;
import com.yeejoin.equipmanage.common.entity.MaintenanceResource;
import com.yeejoin.equipmanage.common.vo.MaintenanceResourceDataVo;
import com.yeejoin.equipmanage.common.vo.MaintenanceResourceVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 维保设施资源树Mapper接口
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
public interface MaintenanceResourceMapper extends BaseMapper<MaintenanceResource> {
    /**
     * 查询维保设施资源树
     *
     * @param id 维保设施资源树ID
     * @return 维保设施资源树
     */
    public MaintenanceResource selectMaintenanceResourceById(Long id);

    /**
     * 查询维保设施资源树列表
     *
     * @param maintenanceResource 维保设施资源树
     * @return 维保设施资源树集合
     */
    public List<MaintenanceResource> selectMaintenanceResourceList(MaintenanceResource maintenanceResource);

    /**
     * 新增维保设施资源树
     *
     * @param maintenanceResource 维保设施资源树
     * @return 结果
     */
    public int insertMaintenanceResource(MaintenanceResource maintenanceResource);

    /**
     * 修改维保设施资源树
     *
     * @param maintenanceResource 维保设施资源树
     * @return 结果
     */
    public int updateMaintenanceResource(MaintenanceResource maintenanceResource);

    /**
     * 删除维保设施资源树
     *
     * @param id 维保设施资源树ID
     * @return 结果
     */
    public int deleteMaintenanceResourceById(Long id);



    /**
     * 批量删除维保设施资源树
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteMaintenanceResourceByIds(Long[] ids);

    List<Map<String, Long>> findTierKeyByParentId(Long parentId);

    List<MaintenanceResourceDto> selectAll();

    List<MaintenanceResourceDto> selectAllType();

    List<MaintenanceResourceDataVo> findByIds(@Param("list") List<Long> ids);

    List<MaintenanceResourceDto> findTreeById(Long id);

    List<MaintenanceResourceDto> selectOwnerUnitList(@Param("id") Long id, @Param("type") Integer type);

    List<MaintenanceResourceDto> findByTypeIn(@Param("ids") String[] types);

    IPage<MaintenanceResourceVo> getFireFightSysPage(Page page, Long maintenanceCompanyId, Long ownerUnitId, Long fireFightSysId, Integer type);

    Boolean updateBatch(@Param("list")List<MaintenanceResource> resourceList);
}
