package com.yeejoin.equipmanage.operation;

import com.yeejoin.amos.boot.biz.common.utils.SecureRandomUtil;
import com.yeejoin.equipmanage.common.vo.AreaResquest;
import com.yeejoin.equipmanage.context.SpringContextHolder;
import com.yeejoin.equipmanage.remote.RiskModelFeign;
import com.yeejoin.equipmanage.remote.RiskSource;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.security.SecureRandom;
import java.util.Random;

@Getter
@AllArgsConstructor
public enum AreaSynRiskOperator {
    ADD("ADD") {
        @Override
        public void apply(AreaResquest areaResquest) {
            RiskModelFeign riskModelFeign = SpringContextHolder.getBean(RiskModelFeign.class);
            RiskSource riskSource = getRiskSource(areaResquest);
            riskModelFeign.addSyncRisk(riskSource);
        }
    },
    UPDATE("UPDATE") {
        @Override
        public void apply(AreaResquest areaResquest) {
            RiskModelFeign riskModelFeign = SpringContextHolder.getBean(RiskModelFeign.class);
            RiskSource riskSource = getRiskSource(areaResquest);
            riskModelFeign.updateAreaSyn(riskSource);
        }
    };

    public RiskSource getRiskSource(AreaResquest areaResquest){
        RiskSource riskSource = new RiskSource();
        StringBuilder code = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 24; i++) {
            code.append(SecureRandomUtil.getIntSecureRandom(10, random));
        }
        riskSource.setCode(code.toString());
        riskSource.setId(Long.parseLong(String.valueOf(areaResquest.getId())));
        riskSource.setName(areaResquest.getName());
        riskSource.setParentId(areaResquest.getRiskPointId());
        return riskSource;
    }

    public abstract void apply(AreaResquest areaResquest);

    private String type;
}
