package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.equipmanage.common.entity.EquProperty;
import com.yeejoin.equipmanage.common.entity.EquipmentDetail;
import com.yeejoin.equipmanage.common.vo.EquipmentDate;

import java.util.List;
import java.util.Map;

/**
 * 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IEquipmentDetailService extends IService<EquipmentDetail> {

	EquipmentDetail saveOne(EquipmentDetail equipmentDetail);

	boolean updateOneById(Long id, EquipmentDetail equipmentDetail);

	Page<EquipmentDetail> page(Page<EquipmentDetail> pageBean, EquipmentDetail equipmentDetail);

	EquipmentDetail getOneById(Long id);

	boolean removeOneById(long id);

	Page<EquipmentDetail> page(Page<EquipmentDetail> pageBean, String category);

	boolean removeBatchById(List<Long> idList);
	boolean quotaUpdate( List<EquProperty> e);

	String getPref(String id);

	String checkDelete( List<Long> ids);

	List<OrgMenuDto> companyDeptTree();

	Map<String, Object> getEquipScrapDate(long id);

	EquipmentDate getEquipmentBasicInformation(Long id, Long stockDetailId);
}
