package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.FormGroupColumnEquip;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IFormGroupColumnEquipService extends IService<FormGroupColumnEquip> {
    /**
     * 查询指定分组的字段
     * @param groupCode 分组
     * @return List<FormGroupColumn>
     */
    List<FormGroupColumnEquip> queryByGroup(String groupCode);

    /**
     * 枚举处理
     * @param fieldName 需要处理的字段名
     * @param value 需要处理的字段值
     * @return Map<String, Map<String, Object>>
     */
    Map<String, Map<String, Object>> processEnumData(String fieldName, String value);
}
