package com.yeejoin.equipmanage.service;

import com.yeejoin.equipmanage.common.enums.SourceTypeEnum;

public interface ISourceStatistics {

    /**
     * 装备、车辆按照单位及分类统计
     *
     * @param bizOrgCode   单位部门code
     * @param sourceType   资源类型
     * @param categoryCode 资源分类code
     * @return int 数量
     */
    int equipCategoryStatistics(String bizOrgCode, SourceTypeEnum sourceType, String categoryCode, boolean isRoot);

    /**
     * 初始化所有有分类数据（装备、车辆），bizOrgCode + "_" + sourceType.getCode() + "_" + categoryCode
     * * 消防装备、消防车辆页面右侧构建分类树，统计装备和车辆数量使用
     * * @param sourceType sourceType
     */
    void initAllCategoryStatisticsData(SourceTypeEnum sourceType);
}
