package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.Warehouse;

import java.util.List;

/**
 * 仓库信息 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IWarehouseService extends IService<Warehouse> {

	boolean removeOneById();

	boolean removeBatchById(List<Long> idList) throws Exception;

	int getOneByName(Warehouse warehouse);
	
	/**
	 * 
	 * 远程同步新增修改仓库货架信息
	 *
	 * @param source
	 * @return String
	 * @throws <br>
	 * @author 张展弋
	 * @date 2020-9-8 18:34:55
	 */
	String saveAutoSysSyn(Warehouse source);
	/**
	 * 
	 * 远程同步删除仓库货架信息 
	 *
	 * @param sourceId
	 * @return String
	 * @throws <br>
	 * @author 张展弋
	 * @date 2020-9-8 18:13:14
	 */
//	String deleteAutoSysSyn(Long sourceId);
}
