package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.FormGroupEquip;
import com.yeejoin.equipmanage.mapper.FormGroupEquipMapper;
import com.yeejoin.equipmanage.service.IFormGroupEquipService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Optional;

/**
 * @author DELL
 */
@Service
public class FormGroupEquipServiceImpl extends ServiceImpl<FormGroupEquipMapper, FormGroupEquip> implements IFormGroupEquipService {

    @Value("${systemctl.dict.allow-operation}")
    private String allowOperation;

    /**
     * @param groupCode
     * @Description 根据groupCode查询
     * @Return FormGroup
     * @Date 2020/12/18 10:01
     */
    @Override
    public FormGroupEquip allowOperationByGroupCode(String groupCode) {
        FormGroupEquip formGroup = this.getOne(new QueryWrapper<FormGroupEquip>()
                .lambda()
                .eq(FormGroupEquip::getGroupCode, groupCode));
        Optional.ofNullable(formGroup).orElseThrow(() -> new BadRequest("分组CODE查询formGroup不存在"));
        return formGroup;
    }

    @Override
    public FormGroupEquip getByUniqueKey(String groupCode) {
        QueryWrapper<FormGroupEquip> wrapper = new QueryWrapper<>();
        wrapper.eq("group_code", groupCode);
        return this.getOne(wrapper);
    }
}
