package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.equipmanage.common.entity.TopographyNode;
import com.yeejoin.equipmanage.common.entity.dto.TopographyNodeDTO;
import com.yeejoin.equipmanage.mapper.TopographyNodeMapper;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 
 * <pre>
 * 拓扑节点 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: TopographyNodeService.java, v 0.1 2021年10月14日 下午3:31:58 gwb Exp
 *          $
 */
@Component
public class TopographyNodeService extends
		BaseService<TopographyNodeDTO, TopographyNode, TopographyNodeMapper>
{

	/**
	 * 列表查询 示例
	 */
	public List<TopographyNodeDTO> queryForListByTypeAndTreeid(int type,
			String treeid)
	{
		return this.queryForList("", false, type, treeid);
	}

	/**
	 * 根据id查询节点数据
	 */
	public TopographyNodeDTO queryById(String id)
	{
		return this.queryModelByParams(id);
	}

}
