package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.TopographyNode;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("iTopographyNodeDao")
public interface ITopographyNodeDao extends BaseDao<TopographyNode, Long> {

	List<TopographyNode> findByAppIdAndType(String appId,String type);
	
	@Query(value = "select * from f_topography_node " + " where id in (?1)",nativeQuery = true)
	List<TopographyNode> findAllByIds(@Param("ids") List<String> ids);

	TopographyNode findById(String id);

	TopographyNode findByKeyAndAppIdAndType(String nodekey, String appId,String type);

	@Query(value = "select max(`key`) from f_topography_node where app_id = (?1) and type = (?2)",nativeQuery = true)
	Integer queryMaxKeyByAppIdAndType(String appId,String type);

	List<TopographyNode> findByGroupAndAppIdAndType(String key, String appId, String type);

	List<TopographyNode> findByType(String type);

	@Query(value = "select max(`key`) from f_topography_node where type = (?1)",nativeQuery = true)
	Integer queryMaxKeyByType(String type);
	
}
