package com.yeejoin.amos.fas.business.feign;

import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @author DELL
 */
@FeignClient(name="${equipManage.fegin.name}", fallback=MassVisualFallback.class, configuration=FeignConfiguration.class)
public interface IEquipManageFeign {
    /**
     * 解除区域与建筑绑定
     * @param instanceId 建筑id
     */
    @PutMapping(value = "/equip/building/unbind/region")
    void unbindRelation(@RequestParam(value ="instanceId") Long instanceId);

    /**
     * 查询建筑位置全路径
     */
    @GetMapping(value = "/equip/building/getBuildingCodeKeyMap")
    Object getBuildingCodeKey();

    /**
     * 通过instanceId获取实例部分信息
     */
    @GetMapping(value = "/equip/building/getFormInstanceById")
    Map<String, Object> findByInstanceId(@RequestParam(value ="instanceId") Long instanceId);
}
