package com.yeejoin.amos.fas.business.param;

import cn.afterturn.easypoi.excel.annotation.Excel;

public class FireEquipmentParam {

    private Long id;

    @Excel(name = "机构编号(必填)")
    private String orgCode;

    @Excel(name = "编号", orderNum = "1")
    private String code;

    @Excel(name = "装备分类(设备类_0,耗材类_1,视频监控_2,灭火器材_3)", replace = {"设备类_0", "耗材类_1", "视频监控_2", "灭火器材_3"}, orderNum = "2")
    private Integer equipClassify;

    @Excel(name = "装备类型(必填)", orderNum = "3")
    private String equipType;

    @Excel(name = "三维坐标", orderNum = "4")
    private String position3d;

    @Excel(name = "三维楼层", orderNum = "5")
    private String floor3d;

    @Excel(name = "是否室内(必填 0/1)", replace = {"否_0", "是_1"}, orderNum = "6")
    private Integer isIndoor;

    @Excel(name = "装备名称(必填)", orderNum = "7")
    private String name;

    @Excel(name = "保养周期", orderNum = "8")
    private Integer maintenanceCycle = 0;

    @Excel(name = "数量", orderNum = "9")
    private Integer number = 0;

    @Excel(name = "单位", orderNum = "10")
    private String unit;

    @Excel(name = "房间", orderNum = "11")
    private String room;

    @Excel(name = "设备状态", replace = {"正常_0", "告警_1"}, orderNum = "12")
    private Integer equipStatus = 0;

    @Excel(name = "重量", orderNum = "13")
    private Double weight = 0.00;

//    @Excel(name = "风险区域id", orderNum = "14")
    private Long riskSourceId;
    
    @Excel(name = "风险区域编号(必填)", orderNum = "14")
    private String riskSourceCode;

    @Excel(name = "厂商", orderNum = "15", width = 20)
    private String manufacturer;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getEquipClassify() {
        return equipClassify;
    }

    public void setEquipClassify(Integer equipClassify) {
        this.equipClassify = equipClassify;
    }

    public String getEquipType() {
        return equipType;
    }

    public void setEquipType(String equipType) {
        this.equipType = equipType;
    }

    public String getPosition3d() {
        return position3d;
    }

    public void setPosition3d(String position3d) {
        this.position3d = position3d;
    }

    public String getFloor3d() {
        return floor3d;
    }

    public void setFloor3d(String floor3d) {
        this.floor3d = floor3d;
    }

    public Integer getIsIndoor() {
        return isIndoor;
    }

    public void setIsIndoor(Integer isIndoor) {
        this.isIndoor = isIndoor;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaintenanceCycle() {
        return maintenanceCycle;
    }

    public void setMaintenanceCycle(Integer maintenanceCycle) {
        this.maintenanceCycle = maintenanceCycle;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getRoom() {
        return room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public Integer getEquipStatus() {
        return equipStatus;
    }

    public void setEquipStatus(Integer equipStatus) {
        this.equipStatus = equipStatus;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Long getRiskSourceId() {
        return riskSourceId;
    }

    public void setRiskSourceId(Long riskSourceId) {
        this.riskSourceId = riskSourceId;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

	/**
	 * @return the riskSourceCode
	 */
	public String getRiskSourceCode() {
		return riskSourceCode;
	}

	/**
	 * @param riskSourceCode the riskSourceCode to set
	 */
	public void setRiskSourceCode(String riskSourceCode) {
		this.riskSourceCode = riskSourceCode;
	}
}
