package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.core.util.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient("AMOSSECURITY")
public interface AMOSSecurityServer {
	@RequestMapping(value = "/user/users/{companyId}", method = RequestMethod.GET)
	public CommonResponse queryAllUserByCompany(@PathVariable("companyId")  String companyId, @RequestParam("roleType") String roleType);
	
	@RequestMapping(value = "/user/user-tree/{companyId}", method = RequestMethod.GET)
	public CommonResponse queryDeptUserTree(@PathVariable("companyId") String companyId, @RequestParam("roleType") String roleType);
}
