package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.bo.FireParamBo;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 安全监管-单据管理 服务类
 *
 * @author 郑嘉伟
 */
public interface FireRectificationService {

    /**
     * 按条件查询消防整改列表信息
     * @param nameLike 单据模糊查询
     * @param sDate 起始日
     * @param eDate 终止日
     * @param states 状态
     * @param pageNum 页码
     * @return
     */
    Map<String, Object> queryFiresAndCount(String nameLike, String sDate, String eDate, int states, int pageNum ,int pageSize);

    /**
     * 查询详细单据信息
     * @param billNo
     * @return
     */
    Map<String ,Object> selectOneById(String  billNo);

    /**
     * 下载文件
     * @param path
     * @param response
     */
    void downLoadFilesByUrll(String  path, HttpServletResponse response );

    /**
     * 修改单据相关信息
     * @param paramBo
     * @return
     */
    Map<String, String>  updateByid(FireParamBo paramBo);
}
