package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jcs.api.dto.ControllerLogDto;
import com.yeejoin.amos.boot.module.jcs.api.enums.ControllerGroupEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.ControllerTypeEnum;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.ControllerLogServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 联动控制日志记录
 *
 * @author system_generator
 * @date 2021-12-03
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/controller-log")
public class ControllerLogController extends BaseController {

    @Autowired
    ControllerLogServiceImpl controllerLogServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<ControllerLogDto> save(@RequestBody ControllerLogDto model) {
        model = controllerLogServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<ControllerLogDto> updateBySequenceNbrControllerLog(@RequestBody ControllerLogDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(controllerLogServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(controllerLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<ControllerLogDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(controllerLogServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 获取今天的记录
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取今天的记录", notes = "获取今天的记录")
    @GetMapping(value = "/selectToday")
    public ResponseModel<List<Map<String, Object>>> selectToday() {
        List<Map<String, Object>> controllerLogDtos = controllerLogServiceImpl.selectToday();
        controllerLogDtos.forEach(item -> {
            item.put("station", ControllerGroupEnum.getEnum(Integer.parseInt(item.get("station").toString())).getName());
            item.put("type", ControllerTypeEnum.getEnum(item.get("type").toString()).getName());
        });
        return ResponseHelper.buildResponse(controllerLogDtos);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<ControllerLogDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<ControllerLogDto> page = new Page<ControllerLogDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(controllerLogServiceImpl.queryForControllerLogPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ControllerLogDto>> selectForList() {
        return ResponseHelper.buildResponse(controllerLogServiceImpl.queryForControllerLogList());
    }
}
