package com.yeejoin.amos.knowledgebase.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocCategoryModel;
import com.yeejoin.amos.knowledgebase.face.service.DocCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 知识库文档分类 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "doccategory")
@RequestMapping(value = "/v1/doccategory")
@Api(tags = "knowledgebase-知识库文档分类")
public class DocCategoryResource {

    private final Logger logger = LogManager.getLogger(DocCategoryResource.class);
    @Autowired
    private DocCategoryService docCategoryService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "创建")
    @RequestMapping(value = "", method = RequestMethod.POST)
    public ResponseModel<KnowledgeDocCategoryModel> create(@RequestBody KnowledgeDocCategoryModel model) {
        model = docCategoryService.createOne(model);
        return ResponseHelper.buildResponse(model);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    public ResponseModel<KnowledgeDocCategoryModel> update(
            @RequestBody KnowledgeDocCategoryModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(docCategoryService.updateOne(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询单个对象")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.GET)
    public ResponseModel<KnowledgeDocCategoryModel> seleteOne(@PathVariable("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(docCategoryService.queryBySeq(sequenceNbr));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分页查询")
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public ResponseModel<Page> queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) {
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(docCategoryService.queryForKnowledgeDocCategoryPage(page, RequestContext.getAgencyCode()));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "列表查询")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseModel selectForList(@RequestParam(value = "parentId", required = false) Long parentId) {
        return ResponseHelper.buildResponse(docCategoryService.queryForKnowledgeDocCategoryList(parentId));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档分类树查询")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    public ResponseModel<Collection<KnowledgeDocCategoryModel>> docCategoryTree() {
        return ResponseHelper.buildResponse(docCategoryService.queryDocCategoryTree(RequestContext.getAgencyCode(), 0L));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档分类树删除")
    @RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
    public ResponseModel<List<Long>> deleteDocCategory(@PathVariable("ids") String ids) {
        return ResponseHelper.buildResponse(docCategoryService.deleteDocCategory(ids));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档分类树查询-携带文档基本信息(包含根节点信息)")
    @RequestMapping(value = "/tree-extra", method = RequestMethod.GET)
    public ResponseModel<Collection> docCategoryTreeExtra(@RequestParam(value = "root", required = false) Long root,
                                                          @RequestParam(value = "onlyPublish", defaultValue = "true", required = false) Boolean onlyPublish,
                                                          @RequestParam(value = "orgCode",required = false)String orgCode) {
        if (ValidationUtil.isEmpty(root)) {
            root = DocCategoryService.ROOT;
        }
        return ResponseHelper.buildResponse(docCategoryService.queryDocCategoryTreeExtra(RequestContext.getAgencyCode(), root, onlyPublish,orgCode));
    }
}
