package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagGroupModel;
import com.yeejoin.amos.knowledgebase.face.service.TagGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 标签分组 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "taggroup")
@RequestMapping(value = "/v1/taggroup")
@Api(tags = "knowledgebase-标签分组")
public class TagGroupResource {

    private final Logger logger = LogManager.getLogger(TagGroupResource.class);
    @Autowired
    private TagGroupService tagGroupService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "创建标签分组.")
    @RequestMapping(value = "", method = RequestMethod.POST)
    public ResponseModel<KnowledgeTagGroupModel> createGroup(@RequestBody KnowledgeTagGroupModel model) {
        if (ValidationUtil.isEmpty(model)
                || ValidationUtil.isEmpty(model.getGroupName()))
            throw new BadRequest("参数校验失败.");
        return ResponseHelper.buildResponse(tagGroupService.createGroup(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新标签分组")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    public ResponseModel<KnowledgeTagGroupModel> updateGroup(
            @RequestBody KnowledgeTagGroupModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {

        if (ValidationUtil.isEmpty(model)
                || ValidationUtil.isEmpty(model.getGroupName()))
            throw new BadRequest("参数校验失败.");

        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(tagGroupService.updateGroup(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除标签分组")
    @RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
    public ResponseModel<List<Long>> deleteGroup(@PathVariable("ids") String ids) {
        return ResponseHelper.buildResponse(tagGroupService.deleteGroup(ids));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "标签分组树结构")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    public ResponseModel<Collection<KnowledgeTagGroupModel>> groupTree(@RequestParam("groupName") String groupName) {
        return ResponseHelper.buildResponse(tagGroupService.queryGroupTree(RequestContext.getAgencyCode(),groupName));
    }



}
