package com.yeejoin.amos.knowledgebase.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 知识库文档存储
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class KnowledgeDocContentModel extends BaseModel {

    /**
     * 富文本内容存储
     */
    private String htmlContent;
    /**
     * 文档状态：发布，未发布
     */
    private String docStatus;
    /**
     * 录入者id
     */
    private String userId;
    /**
     * 录入者姓名
     */
    private String userName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 是否有附件
     */
    private Boolean haveAttachment;
    /**
     * 摘要
     */
    private String summary;
    /**
     * 机构编号
     */
    private String agencyCode;

    /**
     * 审核状态:通过，驳回，待审核，待提交
     **/
    private String auditStatus;

    /**
     * 驳回意见
     **/
    private String rejectionComment;

    /**
     * 审核人id
     **/
    private String auditorUserId;

    private String orgCode;

    /**
     * 纯文本内容
     */
    private String textContent;

    /**
     * 排序内容
     */
    private String sortStr;

    /**
     * 所属目录
     */
    private Long directoryId;

    /**
     * 文档标题
     */
    private String docTitle;


    private String directoryName; // 目录名称
    private Date lastUpdateTime;
    private Map<String, Object> docBaseInfo; // 文档基础信息<feildName,value>
    private List<KnowledgeTagInstanceModel> docTags; // 文档标签<tagInstanceModel,>
    private List<KnowledgeTagInstanceModel> docContentTags; // 文档内容标签<tagInstanceModel>
    private List<KnowledgeTagInstanceModel> tagsToShow; // 只能搜索列表显示的标签信息
    private List<AttachmentModel> attachments; // 附件信息;<附件id,附件原始名称>
    private Boolean collected; // 收藏标识


    public Date getLastUpdateTime() {
        return recDate;
    }
}
