package com.yeejoin.amos.latentdanger.core.framework;

import com.yeejoin.amos.latentdanger.business.util.CommonResponse;
import com.yeejoin.amos.latentdanger.business.util.CommonResponseUtil;
import com.yeejoin.amos.latentdanger.exception.PermissionException;
import com.yeejoin.amos.latentdanger.exception.YeeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * @author DELL
 */
@ControllerAdvice
public class ExceptionHandler {

	private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);

	@org.springframework.web.bind.annotation.ExceptionHandler(PermissionException.class)
    @ResponseBody
    public CommonResponse handlePermissionException(HttpServletRequest request, HttpServletResponse resp, PermissionException ex) {
		resp.setStatus(HttpStatus.UNAUTHORIZED.value());
        return CommonResponseUtil.failure(ex.getMessage());
    }

	@org.springframework.web.bind.annotation.ExceptionHandler(YeeException.class)
    @ResponseBody
    public CommonResponse handleYeeException(HttpServletRequest request, YeeException ex) {
        return CommonResponseUtil.failure(ex.getMessage());
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(Exception.class)
    @ResponseBody
    public CommonResponse handleException(HttpServletRequest request, Exception ex) {
    	return CommonResponseUtil.failure(ex.getMessage());
    }
}
