package com.yeejoin.amos.maintenance.business.service.impl;

import java.util.List;

import com.yeejoin.amos.maintenance.business.dao.repository.IMeasuresDao;
import com.yeejoin.amos.maintenance.business.service.intfc.IMeasuresService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yeejoin.amos.maintenance.dao.entity.Measure;

@Service("measuresService")
public class MeasuresServiceImpl implements IMeasuresService {
	
	@Autowired
	private IMeasuresDao measuresDao;
	@Override
	
	public List<Measure> queryMeasuresByPointID(int pointID) {
		return measuresDao.queryMeasuresByPointID(pointID);
	}
	
	@Override
	public Measure saveMeasures(Measure measure) {
		return measuresDao.save(measure);
	}

	@Override
	public Measure findById(Long id) {
		return measuresDao.findById(id).get();
	}

}
