package com.yeejoin.amos.supervision.business.controller;


import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.supervision.business.param.TaskStatisticsParam;
import com.yeejoin.amos.supervision.business.service.impl.TaskReportService;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.business.util.CommonResponseUtil;
import com.yeejoin.amos.supervision.business.util.Toke;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

@RestController
@RequestMapping(value = "/api/task/report")
@Api(tags="巡检完成情况月报表")
public class TaskReportController extends AbstractBaseController{
	private final Logger log = LoggerFactory.getLogger(TaskReportController.class);


	@Autowired
	private TaskReportService taskReportService;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "  巡检完成情况月报表", notes = " 巡检完成情况月报表")
	@RequestMapping(value = "/{statistical}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse taskReport(
					@ApiParam(value = "统计口径", required = true) @PathVariable String statistical,
					@ApiParam(value = "开始日期", required = true) @RequestParam String startDate,
					@ApiParam(value = "结束日期", required = true) @RequestParam String endDate,
					@ApiParam(value = "所属计划") @RequestParam(required = false) Integer planId,
					@ApiParam(value = "所属路线") @RequestParam(required = false) Integer routeId)
	{
		startDate += " 00:00:00";
		endDate += " 23:59:59";
		ReginParams reginParams = getSelectedOrgInfo();
		String orgCode = getOrgCode(reginParams);
		return CommonResponseUtil.success(taskReportService.queryForTaskReport(getToken(),getProduct(),getAppKey(),statistical,startDate,endDate,planId,routeId,orgCode));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "  人员综合统计分析", notes = " 人员综合统计分析")
	@PostMapping(value = "/comprehensive/user", produces = "application/json;charset=UTF-8")
	public CommonResponse comprehensiveStatisticalForUser(
			@RequestBody(required = true) TaskStatisticsParam param)
	{
		Toke toke = new Toke();
		toke.setToke(getToken());
		toke.setProduct(getProduct());
		toke.setAppKey(getAppKey());
      if(param!=null&&param.getStartTime()!=null&&param.getEndTime()!=null)
		return CommonResponseUtil.success(taskReportService.comprehensiveStatisticalForUser(toke,getProduct(),getAppKey(),param.getStartTime(),param.getEndTime()));
	  else
	  	return CommonResponseUtil.failure("参数有误");
	}

}
