package com.yeejoin.amos.supervision.business.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.supervision.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.supervision.business.entity.mybatis.EquipmentInputItemRo;
import com.yeejoin.amos.supervision.business.util.StringUtil;
import com.yeejoin.amos.supervision.business.util.Toke;
import com.yeejoin.amos.supervision.business.service.intfc.IEquipmentHandlerService;
import com.yeejoin.amos.supervision.common.enums.RuleTypeEnum;
import com.yeejoin.amos.supervision.dao.entity.InputItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;

/**
 * @author keyong
 * @title: HandlerMqttMessageImpl
 * <pre>
 * @description: 订阅装备信息系统消息处理类
 * </pre>
 * @date 2020/11/10 18:03
 */
@Component("IEquipmentHandlerService")
public class EquipmentHandlerServiceImpl implements IEquipmentHandlerService {
    private final Logger log = LoggerFactory.getLogger(EquipmentHandlerServiceImpl.class);
    @Value("websoketUrl")
    public String websoketUrl;
    @Autowired
    private RuleTrigger ruleTrigger;
    @Autowired
    private IInputItemDao iInputItemDao;


    @Async("asyncTaskExecutor")
    @Override
    public void fireEquipRuleMessagePush(HashMap<String, Object> map, Toke token) {
        EquipmentInputItemRo equipmentInputItemRo = new EquipmentInputItemRo();
        equipmentInputItemRo.setEquipmentName(map.get("name").toString());
        equipmentInputItemRo.setOrgCode(map.get("orgCode").toString());
        equipmentInputItemRo.setRuleType(RuleTypeEnum.GETCONTENT.getCode());
        try {
            RequestContext.setToken(token.getToke());
            RequestContext.setProduct(token.getProduct());
            log.info("维保消息规则推送" + JSONObject.toJSONString(equipmentInputItemRo));
            String packageld ="";
            if(StringUtil.isNotEmpty(map.get("inspectionSpecId"))){
                packageld = "维保规范/"+map.get("inspectionSpecId").toString();
            }
            log.info("维保消息规则推送参数 equipmentInputItemRo {}，packageld{}" + JSONObject.toJSONString(equipmentInputItemRo) + JSONObject.toJSONString(packageld));
            ruleTrigger.publish(equipmentInputItemRo, packageld, null);
        } catch (Exception e) {
            log.error(e.getMessage(),e);
        }
    }

    @Override
    public List<InputItem>  getEquipmnetRules(String orgCode,String equipmentName) {
        List<InputItem> inputItems =  iInputItemDao.findByOrgCodeAndEquipmentName(orgCode,equipmentName);
        return inputItems;
    }

    @Override
    public List<InputItem>  getEquipmnetRulesByName(String equipmentName) {
        List<InputItem> inputItems =  iInputItemDao.findByEquipmentName(equipmentName);
//        List<InputItem> inputItems =inputItemMapper.queryCustomInputItem(param);
        return inputItems;
    }

    @Override
    public void getRulesCheckResult(List<EquipmentInputItemRo> rulesCheckList, Toke toke) {
            RequestContext.setToken(toke.getToke());
            RequestContext.setProduct(toke.getProduct());
            System.out.println("rulesCheckList"+JSON.toJSONString(rulesCheckList));
            rulesCheckList.forEach(equimentInputItemRo -> {
                try {
                    ruleTrigger.publish(equimentInputItemRo, "消防设备维保规范/YEEJOIN", null);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
    }
//    @Scheduled(fixedRate=5000)
//    private void equipmentTasks() {
//     iInputItemDao.deleteAllByEquipmentNameIsNotNull();
//     iPointClassifyDao.find
//     iInputItemDao
//
//    }

}
