package com.yeejoin.amos.supervision.business.util;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordFactory implements AbstractHtml {

    private static final Logger log = LoggerFactory.getLogger(WordFactory.class);

    /**
   * 将word转换为html
   * 
   * @param inputFile 需要转换的word文档
   * @param outputFile 转换为html文件名称（全路径）
   * @throws Exception
   */

@Override
public void createHtml(String inputFile, String outputFile) throws Exception {
    log.info("将word转换为html文件开始,输出文件 [" + outputFile + ".html]......");
    long startTime = System.currentTimeMillis();
    AbstractHtml html = new WordHtml();
    html.createHtml(inputFile, outputFile);
    log.info("将word转换为html文件......ok");
    log.info("Generate " + outputFile + ".html with " + (System.currentTimeMillis() - startTime)
        + " ms.");
}

}

