package com.yeejoin.amos.supervision.core.start;

import com.yeejoin.amos.supervision.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.supervision.business.service.intfc.IPointService;
import com.yeejoin.amos.supervision.quartz.IJobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component 
public class ApplicationStartListener implements ApplicationListener<ContextRefreshedEvent> {

	//private static final Logger log = Logger.getLogger(ApplicationStartListener.class);
	
	@Autowired
	private IJobService jobService;
	
	@Autowired
	private IPointService pointService;
	
	@Autowired
	private IPlanTaskService iPlanTaskService;
	
	@Override
	public void onApplicationEvent(ContextRefreshedEvent event) {
		try{
			if(event.getApplicationContext().getParent().getParent() == null){
				iPlanTaskService.initPlanStatusOrGenDate();
				pointService.initPointStatus();
				jobService.initScheduler();
			}
		}catch (Exception e) {
			// TODO: handle exception
			//log.error(e.getMessage(), e);
		}
		
	}

}
