package com.yeejoin.amos;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collections;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

/**
 * Created by magintursh on 2017-05-03.
 */

@EnableScheduling
@EnableFeignClients
@EnableDiscoveryClient
@EnableEurekaClient
@EnableAsync
@MapperScan({"com.yeejoin.amos.knowledgebase.face.orm.dao*",
        "org.typroject.tyboot.face.*.orm.dao*",
        "org.typroject.tyboot.core.auth.face.orm.dao*",
        "org.typroject.tyboot.component.*.face.orm.dao*",
        "com.yeejoin.amos.boot.biz.common.dao.mapper"})
@SpringBootApplication(scanBasePackages = {"com.yeejoin.amos","org.typroject"})
public class KnowledgebaseApplication {
	private static final Logger logger = LoggerFactory.getLogger(KnowledgebaseApplication.class);
    public static void main(String[] args)  throws UnknownHostException{
        SpringApplication application = new SpringApplication(KnowledgebaseApplication.class);
        ConfigurableEnvironment environment = new StandardEnvironment();
        int randomClientId = new SecureRandom().nextInt(65536 - 1024) + 1024;
        environment.getPropertySources().addFirst(new MapPropertySource("securityRandomSource",
                Collections.singletonMap("security-random-int", randomClientId)));
        application.setEnvironment(environment);
        ConfigurableApplicationContext run = application.run();
        String appName = environment.getProperty("spring.application.name");

//        ConfigurableApplicationContext context = new SpringApplicationBuilder(KnowledgebaseApplication.class).web(WebApplicationType.SERVLET).run(args);
        GlobalExceptionHandler.setAlwaysOk(true);
        logger.info(
                "\n----------------------------------------------------------\n\t"
                        + "Application {} is running!\n"
                        + "----------------------------------------------------------\n"
                , appName
        );
    }
}
