<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:th="http://www.thymeleaf.org">
<head>
    <META http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <style type="text/css">.b1 {
            white-space-collapsing: preserve;
        }

        html {
            width: 800px;
        }

        body {
            width: 800px;
        }

        .b2 {
            margin: 1.0in 1.25in 1.0in 1.25in;
        }

        .p1 {
            text-align: center;
            hyphenate: auto;
            font-family: Calibri;
            font-size: 10pt;
        }

        .p2 {
            text-align: center;
            hyphenate: auto;
            font-family: 微软雅黑;
            font-size: 10pt;
        }

        .p3 {
            text-align: justify;
            hyphenate: auto;
            font-family: Calibri;
            font-size: 10pt;
        }

        .td1 {
            width: 1.5729166in;
            padding-start: 0.0in;
            padding-end: 0.0in;
            border-bottom: thin solid black;
            border-left: thin solid black;
            border-right: thin solid black;
            border-top: thin solid black;
        }

        .td2 {
            width: 4.71875in;
            padding-start: 0.0in;
            padding-end: 0.0in;
            border-bottom: thin solid black;
            border-left: thin solid black;
            border-right: thin solid black;
            border-top: thin solid black;
        }

        .td3 {
            width: 6.2916665in;
            padding-start: 0.0in;
            padding-end: 0.0in;
            border-bottom: thin solid black;
            border-left: thin solid black;
            border-right: thin solid black;
            border-top: thin solid black;
        }

        .s1 {
            color: #111f2c;
        }

        .r1 {
            height: 0.48541668in;
            keep-together: always;
        }

        .r2 {
            height: 0.95625in;
            keep-together: always;
        }

        .r3 {
            height: 0.97152776in;
            keep-together: always;
        }

        .t1 {
            table-layout: fixed;
            border-collapse: collapse;
            border-spacing: 0;
        }

        .fileList {
            width: 700px;
        }

        .fileList img {
            width: 700px;
        }

    </style>
    <meta content="DELL" name="author"/>
</head>
<body class="b1 b2">
<table class="t1">
    <tbody>
    <tr class="r1">
        <td class="td1" rowspan="2"><p class="p1"><span>安全技术交底表</span></p></td>
        <td class="td1"><p class="p1"><span>代号</span></p></td>
        <td class="td1"><p class="p2"><span class="s1">${(code)!''}</span></p></td>
        <td class="td1" rowspan="2"><p class="p1"><img src="${(qrCode)!''}"
                                                       style="width:2in;height:2in;vertical-align:text-bottom;"/>
            </p></td>
    </tr>
    <tr class="r1">
        <td class="td1"><p class="p1"><span>编码</span></p></td>
        <td class="td1"><p class="p2"><span class="s1">${(number)!''}</span></p></td>
    </tr>
    <tr class="r1">
        <td class="td1"><p class="p1"><span>项目名称</span></p></td>
        <td class="td2" colspan="3"><p class="p2"><span class="s1">${(projectName)!''}</span></p></td>
    </tr>
    <tr class="r1">
        <td class="td1"><p class="p1"><span>方案名称</span></p></td>
        <td class="td2" colspan="3"><p class="p2"><span class="s1">${(name)!''}</span></p></td>
    </tr>
    <tr class="r1">
        <td class="td1"><p class="p1"><span>主持人</span></p></td>
        <td class="td2" colspan="3"><p class="p2"><span class="s1">
                  <#list hostPersonObject as itemValue>
                      ${(itemValue.personName)!''}
                  </#list>
                </span>
            </p>
        </td>
    </tr>
    <tr class="r1">
        <td class="td1"><p class="p1"><span>施工负责人</span></p></td>
        <td class="td2" colspan="3"><p class="p2"><span class="s1">
                 <#list constructionDirectorObject as itemValue>
                     ${(itemValue.personName)!''}
                 </#list>
                </span>
            </p>
        </td>
    </tr>
    <tr class="r1">
        <td class="td1"><p class="p1"><span>安全员</span></p></td>
        <td class="td2" colspan="3"><p class="p2"><span class="s1">
                 <#list safetyOfficerrObject as itemValue>
                     ${(itemValue.personName)!''}
                 </#list>
                </span>
            </p>
        </td>
    </tr>
    <tr class="r1">
        <td class="td1"><p class="p1"><span>参加交底人员</span></p></td>
        <td class="td2" colspan="3"><p class="p2"><span class="s1">
                 <#list participateDisclosureObject as itemValue>
                     ${(itemValue.personName)!''}
                 </#list>
                </span>
            </p>
        </td>
    </tr>
    <tr class="r1">
        <td class="td3" colspan="4"><p class="p1"><span>交底主要内容</span></p></td>
    </tr>
    <tr class="r1">
        <td class="td3" colspan="4">
            <#if fileList?exists>
                <#list fileList as item>
                    <div class="fileList">
                        ${item}
                    </div>
                </#list>
            </#if>
        </td>
    </tr>
    <tr class="r3">
        <td class="td1"><p class="p1"><span>记录人</span></p></td>
        <td class="td1">
            <p class="p2">
                <span class="s1">
                    <#list noteTakerObject as itemValue>
                     ${(itemValue.personName)!''}
                 </#list>
                </span>
            </p>
        </td>
        <td class="td1"><p class="p1"><span>安全技术交底日</span></p></td>
        <td class="td1"><p class="p2"><span class="s1">${(createDate?string('yyyy-MM-dd HH:mm:ss'))!''}</span></p></td>
    </tr>


    <tr class="r1">
        <td class="td1"><p class="p1"><span>技术交底附件</span></p></td>

        <td class="td2" colspan="3">
            <p class="p2">
                <span class="s1">
                <#if attachment?exists>
                    <#list attachment as item>
                        <#if item.personType!='pdf'>
                            <img height="90" width="160" src="${fileServerUrl + item.filePath}">&nbsp;</img>
                        </#if>
                        <#if item.personType=='pdf'>
                            <a href="${fileServerUrl + item.filePath}">${item.fileName}</a>
                        </#if>
                    </#list>
                </#if>
                </span>
            </p>
        </td>

    </tr>

    </tbody>
</table>
<p class="p3"></p>
<p class="p3"></p>
<p class="p3"></p></body>
</html>